/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: TCPClosing.java
 * Author:   Gunter Weiss
 * Contents: Actions in State CLOSING of TCP-FSM
 * Last Changes: Gunter Weiss 23/5/97
 *****************************************************************************/
import java.util.Vector;
import java.util.Date;

/******************************************************************************
* Class: TCPClosing
* Description: acts corresponding the properties of incoming TCP-Segment
******************************************************************************/
public class TCPClosing {

SegArrive parent;
SessionControlBlock newtcb;
int j;

public SessionControlBlock TCPClosing( SegArrive home, SessionControlBlock newtcb, int j ) {

    this.parent = home;
    this.newtcb = newtcb;
    this.j = j;

    while(true) {
          if(parent.segment1.Seqnumb == newtcb.RCVNXT) {
              if(parent.segment1.RST==1) {
                //System.out.println("Server genau segment mit rst = 1");
                newtcb.partnerresp = -1;
                newtcb.TcpStatus = 0;
                newtcb. retqueue.removeAllElements();
                parent. fromnet.removeElementAt(0);
                parent. tcb.removeElementAt(j);
    	        parent.tcppro.cid--;
                break;
              }
              if(parent.segment1.SYN ==1) {
                parent. fromnet.removeElementAt(0);
                newtcb.TcpStatus = 0;
                parent. tcb.removeElementAt(j);
	            parent.tcppro.cid--;
                break;
              }
          }
          if(parent.segment1.ACK == 1) {
    	      newtcb. setack.setAck();
              newtcb.TcpStatus = 10;
    	      parent. tcppro.darfsenden.getrighttosend();
              newtcb.SNDUNA = parent.segment1.Acknumb;
              newtcb.SNDNXT = parent.segment1.Acknumb +1 ;
              newtcb.RCVNXT = parent.segment1.Seqnumb + 1;
              parent.tcppro.darfsenden.giverighttosend();

          }
	      Timeout t5 = new Timeout(parent.halt,parent.tcppro,10,parent.tcb,newtcb);
          parent. fromnet.removeElementAt(0);

    } //END while(true)
    return newtcb;
} //END methode TCPClosing
} //END class TCPClosing
